------------------------------------------------------
-- Change Paths script, Revision: 2.0
--
-- search for (and replace) a pattern in all filenames in the flow, 
-- including Loader Filename, Proxy,  and Savers. Full support for
-- cliplists.
--
-- place in Fusion:/Scripts/Comp
--
-- TODO Add regular expressions support 
--    - partial / multi matches
--    - autodetection of missing files in dfscriptlib?
--
-- written by Isaac Guenard (izyk@eyeonline.com)
-- created : unknown date, by Isaac Guenard
-- updated : Sept 27, 2005
-- changes : updated for 5
------------------------------------------------------


function conf(filepath)
	filepath = string.lower(filepath)
	findStart, findEnd	= string.find( filepath, srchFor, 1, true )
	print(findStart, findEnd, filepath)
	if findStart == nil then return nil end
	
	-- build the new filename using strStart
	newclip =	string.sub(filepath, 1, findStart - 1) .. 
				srchTo ..
				string.sub(filepath, findEnd + 1)
				
	return newclip
end


-- ask the user for some information
x = composition:AskUser("Repath All Loaders", {
	{"Loaders", "Checkbox", Name = "Loaders", NumAcross = 3, Default = 1},
	{"Savers", "Checkbox", Name = "Savers", NumAcross = 3, Default = 1},
	{"Proxy", "Checkbox", Name = "Proxy", NumAcross = 3, Default = 1},
	{"Source", "Text", Name = "Enter pattern to search for"},
	{"Replacement", "Text", Name = "Enter the replacement path"},
	{"Valid", "Checkbox", Name = "Check If New Path is Valid", Default = 1},
	} )

-- did we get a response, or did they cancel
if x then
	srchFor	= string.lower( bmd.trim( x.Source ) )
	srchTo	= string.lower( bmd.trim( x.Replacement ) )
else
	return nil
end

if srchFor == "" then
	print("What are you searching for?\n")
	return nil
end

if srchTo == "" then
	print("What are you changing ".. srchFor .." to?\n")
	return nil
end

-------------------------
-- lock the flow
-------------------------
composition:Lock()

-------------------------
-- start an undo event
-------------------------
 composition:StartUndo("Path Remap - " .. srchFor .. " to " ..srchTo)

-------------------------
-- get table of tools in flow
-------------------------
toollist	= composition:GetToolList(false)

-------------------------
-- for every tool in the flow
-------------------------

for i, tool in pairs(toollist) do
	tool_a	= tool:GetAttrs()

	-- process only loaders and savers
	if tool_a.TOOLS_RegID == "Loader" then
		
		clipTable = tool_a.TOOLST_Clip_Name
		altclipTable = tool_a.TOOLST_AltClip_Name
		startTime = tool_a.TOOLNT_Clip_Start
		
		-- pass a function the filename, get the newclip back, or nil
		if x.Loaders == 1 then
			for i = 1, table.getn( clipTable ) do
				newclip = conf( clipTable[i] )
				
				if newclip ~= nil then
					if (fileexists(composition:MapPath(newclip)) == false) and (x.Valid == 1) then
						print( "FAILED : New clip does not exist; skipping sequence.\n   " .. newclip)
					else
						tool.Clip[startTime[i]] = newclip
					end
				end
			end
		end
		
		-- pass a function the filename, get the newclip back, or nil
		if x.Proxy == 1 then
			for i = 1, table.getn( altclipTable ) do
				if altclipTable[i] ~= "" then
					newclip = conf( altclipTable[i] )
		
					if newclip ~= nil then
						if (fileexists(composition:MapPath(newclip)) == false) and (x.Valid == 1) then
							print( "FAILED : New proxy clip does not exist; skipping sequence.\n   " .. newclip)
						else
							tool.ProxyFilename[startTime[i]] = newclip
						end
					end
				end
			end
		end
	end
	
	if tool_a.TOOLS_RegID == "Saver" and x.Savers == 1 then
	
		newclip = conf( tool_a.TOOLST_Clip_Name )

		if newclip ~= nil then
			tool.Clip[TIME_UNDEFINED] = newclip
		end
		
	end
end

-------------------------
-- close the undo event
-------------------------
composition:EndUndo(true)

-------------------------
-- unlock the comp
-------------------------
composition:Unlock()
